/*
 * Decompiled with CFR 0.152.
 */
package itx.core.web.filter;

import itx.core.web.BaseController;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.core.web.filter.RequestFilter;
import itx.core.web.filter.RequestFilterList;
import itx.erp.ErpObjectContainer;
import itx.erp.base.controller.AppIndexController;
import itx.erp.base.controller.FourOhFourController;
import itx.erp.base.controller.LangController;
import itx.erp.base.controller.StaticController;
import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.WebSessionService;
import javax.security.sasl.AuthenticationException;
import jtbcore.exception.ContainerException;
import jtbcore.util.DateUtil;

public class RequestAuthFilter
implements RequestFilter {
    protected ErpObjectContainer oc = ErpObjectContainer.getInstance();
    protected WebSessionService webSessionService = this.oc.getWebSessionService();

    @Override
    public void execute(RequestFilterList rfl) throws Exception {
        User u;
        WebRequest req = rfl.getWebRequest();
        String sessionCode = null;
        if (req.hasParameter("jtbauth")) {
            sessionCode = req.getParameter("jtbauth");
            req.setCookie("jtbauth", sessionCode);
        } else {
            sessionCode = req.getCookieValue("jtbauth");
        }
        WebSession session = this.webSessionService.readSession(sessionCode);
        req.setWebSession(session);
        BaseController c = rfl.getWebRequest().getController();
        if (c instanceof RelayBaseController) {
            if (((RelayBaseController)c).checkAuthentication(req)) {
                rfl.next();
                return;
            }
            throw new AuthenticationException("No access to requested controller");
        }
        if (c instanceof LangController) {
            rfl.next();
            return;
        }
        if (c instanceof StaticController) {
            rfl.next();
            return;
        }
        if (c instanceof AppIndexController) {
            rfl.next();
            return;
        }
        if (c instanceof FourOhFourController) {
            rfl.next();
            return;
        }
        if (!(session == null || session.getUserId() == null || (u = this.oc.getUserService().readUser(session.getUserId())) != null && u.isActivated().booleanValue())) {
            req.setWebSession(null);
            session.setUserId(null);
            session = null;
        }
        if (session != null && session.getUserId() != null) {
            this.oc.getWebSessionService().updateTimestamp(session);
            if (session.getExpiry() != -1) {
                req.setCookie("jtbauth", session.getCookieValue(), DateUtil.unixTimestamp() + session.getExpiry());
            }
        } else {
            c = this.oc.getController("authController");
            req.setController(c);
        }
        rfl.next();
    }
}

